import { jsxs, jsx } from "react/jsx-runtime";
import { A as Accordion, a as AccordionItem, b as AccordionTrigger, c as AccordionContent } from "./accordion-DjZKTuzo.js";
import { B as Button } from "./button-CoRGprmX.js";
import { C as Card } from "./card-DBOrqCcU.js";
import { D as DashboardLayout } from "./layout-Coo-00Zo.js";
import { usePage, Head, Link } from "@inertiajs/react";
import { MoveLeft, ArrowRight } from "lucide-react";
import "react";
import "@radix-ui/react-accordion";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./sidebar-4chFkdEZ.js";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./sheet-BrIPI26w.js";
import "@radix-ui/react-dialog";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "./appearance-B5i6uI_j.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./language-pQjimNcB.js";
import "./notification-Bii6lhkq.js";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "date-fns";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./app-logo-CP8LgHIG.js";
import "./route-DlE7FdTW.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "./use-lang-44ndmTOc.js";
const Update = ({ language }) => {
  const { props } = usePage();
  const { translate } = props;
  const { settings, button } = translate;
  const groupedObjects = language.properties.reduce(
    (acc, property) => {
      if (!acc[property.group]) {
        acc[property.group] = [];
      }
      acc[property.group].push(property);
      return acc;
    },
    {}
  );
  return /* @__PURE__ */ jsxs("div", { className: "md:px-3", children: [
    /* @__PURE__ */ jsx(Head, { title: settings.translation_update }),
    /* @__PURE__ */ jsxs("div", { className: "mb-6 flex items-center justify-between gap-4", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("h1", { className: "text-2xl font-bold", children: settings.language_properties }),
        /* @__PURE__ */ jsx("p", { className: "text-gray-500", children: settings.translate_language_properties })
      ] }),
      /* @__PURE__ */ jsx(Link, { href: route("language.index"), children: /* @__PURE__ */ jsxs(Button, { children: [
        /* @__PURE__ */ jsx(MoveLeft, {}),
        button.back
      ] }) })
    ] }),
    /* @__PURE__ */ jsx("div", { className: "space-y-4", children: /* @__PURE__ */ jsx(Accordion, { type: "single", collapsible: true, defaultValue: "faq-0", className: "w-full", children: Object.entries(groupedObjects).map(([group, properties], index) => /* @__PURE__ */ jsxs(
      AccordionItem,
      {
        value: `faq-${index}`,
        className: "bg-background border-border mb-4 rounded-lg border px-6 shadow-sm",
        children: [
          /* @__PURE__ */ jsxs(AccordionTrigger, { className: "cursor-pointer py-4 text-base font-semibold capitalize hover:no-underline", children: [
            group,
            " ",
            settings.elements
          ] }),
          /* @__PURE__ */ jsx(AccordionContent, { className: "text-muted-foreground grid grid-cols-1 gap-4 pt-0 pb-4 text-sm sm:grid-cols-2 md:grid-cols-4", children: properties.map((property) => /* @__PURE__ */ jsx(Link, { href: route("language.property.edit", property.id), children: /* @__PURE__ */ jsxs(Card, { className: "hover:border-secondary-light hover:text-secondary-foreground flex items-center justify-between border-2 p-4 !shadow-none", children: [
            /* @__PURE__ */ jsx("p", { className: "font-medium", children: property.name }),
            /* @__PURE__ */ jsx(ArrowRight, { size: 16 })
          ] }) })) })
        ]
      },
      `faq-${index}`
    )) }) })
  ] });
};
Update.layout = (page) => /* @__PURE__ */ jsx(DashboardLayout, { children: page });
export {
  Update as default
};
